#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 16) out;

in vec3 position[3];
in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in float bright[3];
in vec3 origCenter[3];
in vec3 branchInfo[3];

out vec3 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 tangentG;
out float brightG;
out vec3 origCenterG;
out vec3 branchInfoG;

uniform float g_time;
uniform float g_timeStep;
uniform float g_emit = 1.0;

uniform float windowWidth;
uniform float windowHeight;

layout(binding=0) uniform sampler2D tex;

vec3 movePos(vec3 p, vec3 oc) {
    vec3 moveDir = vec3(0.0, 0.80*sin(g_time*0.5)+1.0, 0.0)*pow(1.3, g_timeStep/0.05);

    float fre = 0.15+0.1*sin(g_time+4.7*cos(g_time));
    moveDir.yxz = rotateXZ3(moveDir.yxz, (0.40+oc.y*0.03)*sin(oc.y*2.0*fre+g_time));
    moveDir.zyx = rotateXZ3(moveDir.xyz, (0.40+oc.y*0.03)*cos(oc.x*1.50*fre+oc.z*fre));
    p += moveDir;

    return p;


}

void main(void) {

    float dgl = 3000.0;
    vec3 dd = position[1]-position[0];
    if (dot(dd,dd) > dgl) {
        return;
    }
    dd = position[2]-position[0];
    if (dot(dd,dd) > dgl) {
        return;
    }
    dd = position[2]-position[1];
    if (dot(dd,dd) > dgl) {
        return;
    }

    float type = branchInfo[0].y;
    float replicas = branchInfo[0].z;
    float age = branchInfo[0].x;


    for (int i = 0; i < gl_in.length(); ++i) {
        gl_Position = gl_in[i].gl_Position;
        posG = position[i];
        origCenterG = origCenter[i];

//posG.y += 0.015;
//origCenterG.y += 0.015;

        float d = 800.0;
        if (dot(posG, posG) > d*d) {
            return;
        }
        normalG = normal[i];
        uvG = uv[i];
        tangentG = tangent[i];
        brightG = bright[i];
        branchInfoG = branchInfo[i];
       // if (replicas < 0.5) {
          branchInfoG.z += 1.0;
       // }
        EmitVertex();
    }

    EndPrimitive();

    if (replicas < 0.5 && g_timeStep > 0.0) {
        for (int i = 0; i < gl_in.length(); ++i) {
            gl_Position = gl_in[i].gl_Position;
            posG = position[i];
            origCenterG = origCenter[i];
           // posG.y += 0.01;
           // origCenterG.y += 0.01;

            posG = movePos(posG, origCenterG);
            origCenterG = movePos(origCenterG, origCenterG);

            float d = 800.0;
 //           if (dot(posG, posG) > d*d) {
 //               return;
 //           }
            normalG = normal[i];
            uvG = uv[i];
            tangentG = tangent[i];
            brightG = bright[i];
            // branchInfoG = branchInfo[i];
            branchInfoG.x = 0.0;
            //branchInfoG.y
            branchInfoG.z = 0.0;
            EmitVertex();
        }
        EndPrimitive();
    }

}
